import csv
import pdb
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.colors import ListedColormap

arr = np.genfromtxt("hg00733calls.txt",delimiter='\t',dtype=str)


xhmmcalls = arr[:,15]
deccalls = arr[:,16]
NQs = arr[:,9]
SQs = arr[:,10]
length = arr[:,3]

correctedids = xhmmcalls != deccalls
notcorrectedids = xhmmcalls == deccalls

SQscorrected = SQs[correctedids]
SQsnotcorrected = SQs[notcorrectedids]

NQscorrected = NQs[correctedids]
NQsnotcorrected = NQs[notcorrectedids]


plt.scatter(SQscorrected, NQscorrected, s=78, c='blue',marker="^",label='DECoNT corrected true XHMM calls', alpha=0.8)
plt.scatter(SQsnotcorrected, NQsnotcorrected, s=78, c='red',marker="^",label='True XHMM calls', alpha=0.8)

plt.xlabel("SQ value")
plt.ylabel("NQ value")

plt.legend(loc='upper left')

plt.show()

pdb.set_trace()
plt.show()

pdb.set_trace()